#ifndef KMS_GLOBAL_TYPES_H_
#define KMS_GLOBAL_TYPES_H_

#include "util/logger.h"

// poll time period while waiting for attributes to appear
#define ATTRIBUTE_POLL_TIME_MS		10

// default timeout we are waiting for devices and attributes to appear
#define DEFAULT_TIMEOUT 			1000

// in case no one tells us this parameter we are taking the number of CPUs available using getnprocs(). This function
// might fail in seldom case (directly after a clock reset). In this case we fall back to the number of worker threads
// defined here
#define FALLBACK_WORKER_THREAD_CNT	2

// loglevel used in case nothing is passed as command line option
#define DEFAULT_LOGLEVEL 			LOGGER_LEVEL_ERROR

// error codes
typedef enum error_code_t
{
	RESULT_OK=0,
	RESULT_INVALID,
	RESULT_INVALID_ARGS,
	RESULT_NORESOURCES,
	RESULT_TIMEOUT_EXPIRED,
	RESULT_HELP_PRINTED,
	RESULT_MODULE_BUILTIN,
	RESULT_MODULE_LOADED,
	RESULT_MODULE_NOT_FOUND,
	RESULT_MODLOADING_FAILED,
	RESULT_APPLYING_CREDS_FAILED,
	RESULT_GLOB_NO_MATCHING_PATH,
	RESULT_GLOB_MULTIPLE_MATCHING_PATHS,
	RESULT_CREDENTIALS_EMPTY,
	RESULT_CREDENTIALS_INVALID,
	RESULT_CONF_INVALID,
	RESULT_EVENT_STRING_INVALID,
	RESULT_ATTRIBUTE_INVALID,
	RESULT_WHITESPACE_INVALID,
	RESULT_UEVENT_FILE_NOT_AVAILABLE,
	RESULT_DEVNODE_NOT_AVAILABLE
} error_code_t;

#endif

